﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RaceInfo
{
    class Program
    {
        static void Main(string[] args)
        {
            double kmTravelled = double.Parse(args[0]);
            double elapsedSeconds = double.Parse(args[1]);
            double fuelKilosConsumed = double.Parse(args[2]);

            double fuelTankCapacityKilos = 80;
            double lapLength = 5.141;

            double fuelKilosPerKm = fuelKilosConsumed / kmTravelled;
            double fuelKilosRemaining = fuelTankCapacityKilos - fuelKilosConsumed;
            double predictedDistanceUntilOutOfFuel = fuelKilosRemaining / fuelKilosPerKm;
            double predictedLapsUntilOutOfFuel =
                predictedDistanceUntilOutOfFuel / lapLength;

            if (predictedLapsUntilOutOfFuel < 4)
            {
                Console.WriteLine("Mało paliwa. Można jeszcze przejechać " +
                predictedLapsUntilOutOfFuel + " okrążenia.");
            }


            // Zmienne niezbędne do skompilowanie kodu z Listingu 2.11.
            // W rzeczywistym programie, informacje te zostałyby podane
            // przez użytkownika lub pobrane z bazy danych. Jak widać,
            // ten konkretny przykład jest stosunkowo mało realistyczny.
            bool ourDriverCausedIncident = false;
            bool feelingGenerous = true;


            // Listing 2-11. Testowanie wielu warunków przy wykorzystaniu instrukcji switch i case
            string raceStatus = args[3];
            switch (raceStatus)
            {
                case "YellowFlag":
                    Driver.TellNotToOvertake();
                    break;
                case "SafetyCar":
                    Driver.WarnAboutSafetyCar();
                    break;
                case "RedFlag":
                    if (ourDriverCausedIncident)
                    {
                        Factory.OrderNewCar();
                        Driver.ReducePay();
                        if (feelingGenerous)
                        {
                            Driver.Resuscitate();
                        }
                    }
                    else
                    {
                        Driver.CallBackToPit();
                    }
                    break;
                default:
                    Driver.TellToDriveFaster();
                    break;
            }
        }
    }
}
